<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.plugin.plugin');

class plgForm2ContentMetadata_Generator extends JPlugin 
{
	public function onBeforeF2cContentSave($eventData)
	{
		$this->generateMeta($eventData->formNew->metakey, $eventData->formNew->metadesc, $eventData->formNew->title, $eventData->formNew->alias, $eventData);		
		return true;
	}

	public function onBeforeF2cContentParse($eventData)
	{
		// Only generate metadata for a refresh operation
		if(JRequest::getString('task') == 'refresh')
		{
			$form = JTable::getInstance('Form', 'Form2ContentTable');
			$form->load($eventData->formNew->id);

			if($this->generateMeta($form->metakey, $form->metadesc, $form->title, $form->alias, $eventData))
			{
				$form->store();
			}
		}		
	}
	
	private function generateMeta(&$metakey, &$metadesc, &$title, &$alias, $eventData)
	{
		$save	 		= false;		
		$templatePath 	= F2cFactory::getConfig()->get('template_path');
		$parser 		= new F2cParser();
		
		// Check if the title template is present
		if(JFile::exists(Path::Combine($templatePath, 'title_contenttype_' . $eventData->formNew->projectid . '.tpl')))
		{
			if($parser->addTemplate('title_contenttype_' . $eventData->formNew->projectid . '.tpl', F2C_TEMPLATE_INTRO))
			{
				$eventData->formNew->fields = $eventData->fieldsNew;
				
				$parser->addVars($eventData->formNew);
				
				$title = $parser->parseIntro();

				if($title != $eventData->formOld->title)
				{
					$save = true;
					
					if($this->params->def('create_new_alias', 1))
					{
						// Generate a new alias
						$alias = '';
					}
				}				
			}
		}

		// Check if the alias template is present
		if(JFile::exists(Path::Combine($templatePath, 'alias_contenttype_' . $eventData->formNew->projectid . '.tpl')))
		{
			if($parser->addTemplate('alias_contenttype_' . $eventData->formNew->projectid . '.tpl', F2C_TEMPLATE_INTRO))
			{
				$eventData->formNew->fields = $eventData->fieldsNew;
				
				$parser->addVars($eventData->formNew);
				
				$alias = $parser->parseIntro();
			}
		}
		
		$parser = new F2cParser();
		
		$keywordsTemplateAdded 		= false;
		$descriptionTemplateAdded 	= false;
		$keywordsTemplate 			= 'metadata_keywords_contenttype_' . $eventData->formNew->projectid . '.tpl';
		$descriptionTemplate 		= 'metadata_description_contenttype_' . $eventData->formNew->projectid . '.tpl';
		
		if(JFile::exists(Path::Combine($templatePath, $keywordsTemplate)))
		{
			$keywordsTemplateAdded = $parser->addTemplate($keywordsTemplate, F2C_TEMPLATE_INTRO);
		}
		
		if(JFile::exists(Path::Combine($templatePath, $descriptionTemplate)))
		{
			if($keywordsTemplateAdded)
			{
				$descriptionTemplateAdded = $parser->addTemplate($descriptionTemplate, F2C_TEMPLATE_MAIN);
			}
			else
			{
				$descriptionTemplateAdded = $parser->addTemplate($descriptionTemplate, F2C_TEMPLATE_INTRO);
			}
		}
		
		// Check if the keywords and description templates are present	
		if($keywordsTemplateAdded || $descriptionTemplateAdded)
		{
			$eventData->formNew->fields = $eventData->fieldsNew;
			
			$parser->addVars($eventData->formNew);
			
			if($keywordsTemplateAdded)
			{
				$save = true;
				$metakey = $parser->parseIntro();
			}
			
			if($descriptionTemplateAdded)
			{
				$save = true;
				$metadesc = $keywordsTemplateAdded ? $parser->parseMain() : $parser->parseIntro();
			}
		}
		
		return $save;
	}
}
?>