<?php
namespace F2cAnywhere;

use Joomla\CMS\Factory;

// no direct access
defined('_JEXEC') or die;

class F2cAnywhereArticle
{
	protected $templatePath = null;
	protected $templateName = null;
	protected $template = null;
	
	const UUID_NAMESPACE = "508d8862-9271-43db-b6ec-f03a95894be1";

	public function __construct()
	{
        require_once(JPATH_SITE.'/components/com_form2content/utils.form2content.php');
        require_once(JPATH_SITE.'/components/com_form2content/factory.form2content.php');
        require_once(JPATH_SITE.'/components/com_form2content/models/form.php');

        \JLoader::registerPrefix('F2c', JPATH_SITE . '/components/com_form2content/libraries/form2content');

		$this->templatePath = \F2cFactory::getConfig()->get('template_path');
	}

	public function render($articleId, $itemCount, $sequenceNumber)
	{
		$modelForm = new \Form2contentModelForm();
		$article = $modelForm->getItem($articleId);

		if (!$article)
		{
			return '';
		}

		$parser = new \F2cParser();
		if (!empty($this->template))
		{
			$parser->addTemplate('string:' . $this->template, F2C_TEMPLATE_INTRO);
		}
		else if (!empty($this->templateName))
		{
			$parser->addTemplate($this->templateName, F2C_TEMPLATE_INTRO);
		}

		$parser->addVars($article);

		$parser->addVar('F2CANYWHERE_SEQUENCE_NUMBER', $sequenceNumber++);
		$parser->addVar('F2CANYWHERE_ITEM_COUNT', $itemCount);

		return $parser->parseIntro();
	}

	protected function saveToFile($template)
	{
		if (!empty($template))
		{
			$uuid = new UUID();
			$fileName = $uuid->v5(self::UUID_NAMESPACE, $template) . '.tpl';
			$filePath = Path::Combine($this->templatePath, $fileName);

			if (!\JFile::exists($filePath))
			{
				file_put_contents($filePath, $template);
			}
		}
		
		return $fileName;
	}

	public function getTemplateName()
	{
		return $this->templateName;
	}

	public function setTemplateName($templateName)
	{
		if (!\JFile::exists(\Path::Combine($this->templatePath, $templateName)))
		{
			throw new F2cAnywhereArticleException('Form2Content template not found.', F2cAnywhereArticleException::TEMPLATE_NOT_FOUND);
		}
		
		$this->templateName = $templateName;

		return $this;
	}

	public function getTemplate()
	{
		return $this->template;
	}

	public function setTemplate($template, $saveToFile = false)
	{
        if ($saveToFile)
        {
            try
            {
                $this->templateName = $this->saveToFile($template);
            }
            catch (Exception $e)
            {
                throw new F2cAnywhereArticleException('Unable to save template to file.', F2cAnywhereArticleException::TEMPLATE_CACHING_ERROR, $e);
            }
        }		
        else
        {
            $this->template = $template;
        }

		return $this;
	}
}