<?php
/**
* @author      Opensource Design, http://www.opensourcedesign.nl
* @copyright   Copyright (C) 2009 Opensource Design. All rights reserved.
* @license     GNU General Public License, http://www.gnu.org/copyleft/gpl.html
* @Version     3.0.0
**/

// no direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

class plgContentF2c_Related_Authors extends JPlugin
{
	public function onContentPrepare($context, &$row, &$params, $page = 0)
	{
		if (JString::strpos($row->text, '{plgContentF2cRelatedAuthors}') === false) 
		{
			return true;
		}

		require_once(JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_form2content'.DIRECTORY_SEPARATOR.'factory.form2content.php');
		
		JLoader::registerPrefix('F2c', JPATH_SITE.'/components/com_form2content/libraries/form2content');
		JLoader::register('Form2contentModelForm', JPATH_SITE.'/components/com_form2content/models/form.php');
		
		$db 			= JFactory::getDbo();
		$templatePath 	= F2cFactory::getConfig()->get('template_path');
		$currentDate	= JFactory::getDate();
		$nullDate 		= $db->getNullDate();
		
		//Find all instances of plugin and put in $matches
		preg_match_all('/{plgContentF2cRelatedAuthors}(.*){\/plgContentF2cRelatedAuthors}/i', $row->text, $matches);

		for ($i=0; $i < count($matches[0]); $i++)
		{
			list($joomlaArticleId, $contentTypeId, $templateInner, $templateOuter) = explode(',', $matches[1][$i]);

			if(strtolower($joomlaArticleId) == 'auto')
			{
				$joomlaArticleId  = JRequest::getInt('id');
			}
			
			$output = '';
			$query = $db->getQuery(true);
			
			$query->select('fm2.reference_id as id');
			$query->from('#__f2c_form fm1');
			$query->join('inner', '#__f2c_form fm2 on fm1.created_by = fm2.created_by');
			$query->where('fm1.reference_id = ' . (int)$joomlaArticleId);			
			$query->where('fm2.projectid = ' . (int)$contentTypeId);
			$query->where('fm2.state = 1');					
			$query->where('(fm2.publish_up < \''.$currentDate->toSql().'\' OR fm2.publish_up = \''.$nullDate.'\')');
			$query->where('(\''.$currentDate->toSql().'\' < fm2.publish_down OR fm2.publish_down = \''.$nullDate.'\')');			
			$query->order('fm2.created DESC');

			$db->setQuery($query);

			$idList = $db->loadAssocList();
			$ids = array();
			
			if(count($idList))
			{
				foreach($idList as $idObject)
				{
					$ids[] = $idObject['id'];	
				}
				
				$idString = implode(',', $ids);
				
				// Load the forms we need to render
				$query = $db->getQuery(true);
				
				$query->select('frm.id, frm.title, frm.alias, frm.created, frm.modified, frm.publish_up, frm.publish_down, frm.reference_id');
				$query->select('frm.catid, frm.metakey, frm.metadesc, frm.created_by, frm.created_by_alias, frm.projectid, frm.language');
				$query->select('frm.extended, frm.featured, frm.modified_by');
				$query->from('#__f2c_form frm');
				$query->select('cat.title AS catTitle, cat.alias AS catAlias');
				$query->join('LEFT', '#__categories cat ON frm.catid = cat.id');
				$query->select('usr.name AS author, usr.username AS authorUsername, usr.email as authorEmail');
				$query->join('LEFT', '#__users usr ON frm.created_by = usr.id');
				$query->where('frm.reference_id IN (' . $idString . ')');

				$db->setQuery($query);
				$formList = $db->loadObjectList('id');
				
				$f2cIds = array();
				
				foreach($formList as $form)
				{
					$f2cIds[] = $form->id;	
				}
				$query = $db->getQuery(true);
		
				$query->select('fc.id AS fieldcontentid, frm.id as formid, fc.fieldid, fc.attribute, fc.content, pf.*, ft.name');				
				$query->from('#__f2c_form frm');
				$query->join('INNER', '#__f2c_projectfields pf on frm.projectid = pf.projectid');
				$query->join('INNER', '#__f2c_fieldtype ft on pf.fieldtypeid = ft.id');
				$query->join('LEFT', '#__f2c_fieldcontent fc on fc.fieldid = pf.id and fc.formid = frm.id');
				$query->where('frm.id in (' . implode(',', $f2cIds) . ')');
				$query->order('pf.ordering, pf.fieldtypeid');
				
				$db->setQuery($query);
				
				$fieldContentList = $db->loadObjectList();
		
				$modelForm = new Form2contentModelForm();
				$fieldContentList = $modelForm->createFormDataObjects($fieldContentList);
				
				if(count($formList))
				{
					foreach($formList as $form)
					{
						if(array_key_exists($form->id, $fieldContentList))
						{
							$form->fields = $fieldContentList[$form->id];
						}
						else
						{
							$form->fields = array();
						}
						
						$form->tags = array();
						
						// Load item tags
		              	$form->extended = new JRegistry($form->extended);
		              	$tagList = $form->extended->get('tags');
		                	
		               	if(!empty($tagList))
		               	{
							$form->tags = explode(',', $tagList);
		               	} 		               	              							
					}
				}
								
				foreach($formList as $form)
				{
					$parser = new F2cParser();
					
					// Check if the title template is present
					if(JFile::exists(Path::Combine($templatePath, $templateInner)))
					{
						if($parser->addTemplate($templateInner, F2C_TEMPLATE_INTRO))
						{
							$parser->addVars($form);
														
							$output .= $parser->parseIntro();
						}
					}
					
				}

				// check if we have an outer template
				if(!empty($templateOuter) && JFile::exists(Path::Combine($templatePath, $templateOuter)))
				{
					$parser = new F2cParser();
					
					if($parser->addTemplate($templateOuter, F2C_TEMPLATE_INTRO))
					{
						$parser->addVar('F2C_RELATED_AUTHORS_OUTPUT', $output);												
						$output = $parser->parseIntro();
					}					
				}
			}
			
			$row->text = str_replace($matches[0][$i], $output, $row->text);
		}

		return true;
	}
}
